Trigger.UnrequestTrigger(PileTrigger)
Script.Load( "Data\\Script\\MapTools\\Main.lua" )
	IncludeLocals("GetRandom")
	IncludeLocals("TriggerFix")
	IncludeLocals("FrameworkWrapperLight")
	IncludeLocals("GetCirclePosition")
	IncludeLocals("GetAngleBetween")
	IncludeLocals("CopyTable")
	if CppLogic then
		IncludeLocals("PredicateHelper")
	end
	IncludeLocals("EntityIDChangedHelper")
	IncludeLocals("GetDistance")
	IncludeLocals("IsEntityOfType")
	IncludeLocals("IsValidPosition")
	IncludeLocals("LuaObject")
	IncludeLocals("TargetFilter")
	IncludeLocals("GetEntityMovementSpeed")
	if CppLogic then
		ArmorClasses = {
			AC_None = 1,
			AC_Jerkin = 2,
			AC_Leather = 3,
			AC_Iron = 4,
			AC_Fortification = 5,
			AC_Hero = 6,
			AC_Fur = 7,
			}
		IncludeLocals("TriggerFixCppLogicExtension")
	end
	IncludeLocals("UnlimitedArmy")
	
	IncludeLocals("SpawenTableIndex")
	
	IncludeLocals("PoisenReiter")
	
	IncludeLocals("SpawnTableIndex")
	
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called from main script to initialize the diplomacy states
function Mission_InitDiplomacy()
	SetHostile(1,2)
end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start and after save game to initialize player colors
function Mission_InitPlayerColorMapping()
		Display.SetPlayerColorMapping(1, ENEMY_COLOR1)
		Display.SetPlayerColorMapping(2, 2)
		
end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called from main script to init all resources for player(s)
function Mission_InitResources()
		AddGold(1000)
		AddWood(1500)
		AddClay(1800)
		AddStone(800)
		AddIron(50)
		AddSulfur(50)
end


--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called to setup Technology states on mission start
function Mission_InitTechnologies()
end


--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start to initialize ai for all ai players
function Mission_InitAI()
end


--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start and after save game is loaded, setup your weather gfx
-- sets here
function Mission_InitWeatherGfxSets()

	-- Use gfx sets
	Display.SetRenderUseGfxSets(1)
	
	-- Use normal weather gfx set
	WeatherSets_SetupNormal(1)
	WeatherSets_SetupSnow(3)
	WeatherSets_SetupRain(2)
end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start you should setup your weather periods here
function Mission_InitWeather()
	
	-- Init with gfx set 1
	Logic.SetupGfxSet(1)
	Logic.AddWeatherElement(1, 5, 1, 1, 5, 10)
end
	
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start after all initialization is done
function Mission_FirstMapAction()
	
	currentWaveLimit = 240
	bombers = {}

	Interface_InitWidgets()
	gvGUI_WidgetID.BuyHeroWindow = XGUIEng.GetWidgetID("BuyHeroWindow")
	
	GUIAction_ToggleMenu_Orig = GUIAction_ToggleMenu
	function GUIAction_ToggleMenu( _Menu, _Status )
		GUIAction_ToggleMenu_Orig(_Menu, _Status)
		if _Menu == gvGUI_WidgetID.BuyHeroWindow then
			XGUIEng.ShowWidget(gvGUI_WidgetID.BuyHeroWindow,-1)
		end
	end
	
	Camera.ZoomSetFactorMax(2)
	
	AddMapStartAndSaveLoadedCallback(IncludeLocals,"ReloadEntitiesTable")
	
	TriggerFix.AllScriptsLoaded()
	
	if CppLogic then
		GetRandom(1,10)
	else
		math.randomseed(PureRandom())
	end
	
	player2 	= {}
	player2.id 	= 2

	local description = {
	    serfLimit = 10
    }
	
	SetupPlayerAi(player2.id,description)

	VisionID = Tools.ExploreArea(1,1,99999)
	
	XGUIEng.ShowWidget("StopWatch",1)
	
	XGUIEng.SetWidgetPositionAndSize("StopWatch", 0, 0, 100, 30)
	
	LocalMusic.SetBattle=  					{
										{ "03_CombatEurope1.mp3", 117 },
										{ "04_CombatMediterranean1.mp3", 113 },
										{ "05_CombatEvelance1.mp3", 117 },
										{ "43_Extra1_DarkMoor_Combat.mp3", 120 }
										}
	
	function
	LocalMusic.CallbackSettlerKilled(_HurterPlayerID, _HurtPlayerID)
	
	local PlayerID = GUI.GetPlayerID()
	
	if _HurterPlayerID ~= _HurtPlayerID and PlayerID == _HurtPlayerID  then		
			if LocalMusic.LastBattleMusicStarted < Logic.GetTime() then					
				if Logic.IsEntityInCategory(_HurterPlayerID,EntityCategories.EvilLeader) == 1 then
					LocalMusic.BattlesOnTheMap = 2
				else
					LocalMusic.BattlesOnTheMap = 1
				end
				LocalMusic.LastBattleMusicStarted = Logic.GetTime() + 127
				LocalMusic.SongLength = 0
			end
		end
	end
	
	function GUIQuestTools.UpdateStopWatch()
		local Seconds = Logic.GetTime()
	
		local TotalMinutes = math.floor( Seconds / 60 )
		local Hours = math.floor( TotalMinutes / 60 )
		local Minutes = math.mod( TotalMinutes, 60 )
		local TotalSeconds = math.mod( math.floor(Seconds), 60 )	
		local String = " "	
		if Hours > 0 then		
			if Hours < 10 then
				String = String .. "0" .. Hours .. ":"
			else
				String = String .. Hours .. ":"
			end
		elseif Hours == 0 then
			String = String .. "00".. ":"
		end
		
		if Minutes == 0 then
			String = String .. "00" .. ":"
		else
			if Minutes <10 then
				String = String .. "0" .. Minutes .. ":"
			else
				String = String .. Minutes .. ":"
			end
		end	
		if TotalSeconds < 10 then		
			String = String .. "0" .. TotalSeconds	
		else		
			String = String .. TotalSeconds	
		end	
		XGUIEng.SetText("StopWatchCounter", String)	
	end
	
	function GUIUpdate_BuyHeroButton()
	
		local PlayerID = GUI.GetPlayerID()
		local NumberOfHerosToBuy = Logic.GetNumberOfBuyableHerosForPlayer( PlayerID )
		
		
		if NumberOfHerosToBuy > 0 then
			XGUIEng.ShowWidget(XGUIEng.GetCurrentWidgetID(),1)		
		else
			XGUIEng.ShowWidget(XGUIEng.GetCurrentWidgetID(),0)		
		end
	end
	
	Logic.SetNumberOfBuyableHerosForPlayer(1, 5)
	
	Logic.SetEntitySelectableFlag(GetID("player1"), 0)
	Logic.SetEntitySelectableFlag(GetID("player1DZ"), 0)
	ShuffleMines()
	CreateArmies()
	
	XGUIEng.ShowWidget("MainMenuWindow_SaveGame",0)
	XGUIEng.ShowWidget("MainMenuWindow_SaveGameOverlay",0)
	Input.KeyBindDown(Keys.F6,"", 2 )
	
	XGUIEng.ShowWidget("Movie",1)
	XGUIEng.ShowWidget("MovieBarTop",0)
	XGUIEng.ShowWidget("MovieBarBottom",0)
	XGUIEng.ShowWidget("CreditsWindowLogo",0)
	XGUIEng.ShowWidget("MovieInvisibleClickCatcher",0)
	XGUIEng.SetText("CreditsWindowTextTitle", "Willkommen!", 1)
	XGUIEng.SetText("CreditsWindowText", "Dies hier ist eine Überlebenskarte im Unendlich-Modus @cr @cr Sobald ihr das Spiel über das Tributmenü startet, geht es los. @cr Jede Runde ist individuell. Seht euch die Karte gut an bevor ihr startet. @cr @cr Speichern könnt ihr, nachdem ihr gestartet habt.", 1)

	LocalMusic.UseSet = HIGHLANDMUSIC
	
	DefeatJob = StartSimpleJob("CheckHQ")
	bombtrigger = StartSimpleJob("controlBombs")
	
	local job = {}
			
	job.Tribute = 1
	Logic.AddTribute(1,
					1,
					0,
					0,
					"Die Runde Defeat The Waves starten. @cr @color:255,0,0 ÜBERLEBT!",
					ResourceType.Gold,
					0)
	job.Callback = StartGame
			
	SetupTributePaid(job)
end

function CheckHQ()
	if IsDead("player1") then
		Defeat()
		XGUIEng.SetText("GameEndScreen_Message", "@center Ihr habt bis Welle "..(math.floor(wavecounter/currentWaveLimit)-1).." überlebt")
	end
	return false
end

FormationFunktion = function(self, truppid)
	if Logic.IsEntityInCategory(truppid, EntityCategories.EvilLeader)==1 then
		return 1
	end
	return 4
end

function CreateArmies()
	UAArmies = {}
	for i =1,40,1 do
		UAArmies[i] = LazyUnlimitedArmy:New({
			Player = 2,
			Area = 3800,
			TransitAttackMove = true,
			Formation = UnlimitedArmy.Formations.Chaotic,
			AIActive = true,
			LeaderFormation = FormationFunktion,
			DoNotNormalizeSpeed = true,
			HiResJob = true
			},
			i,
			41)
		UAArmies[i]:AddCommandMove(GetPosition("player1"),false)
		UAArmies[i]:AddCommandLuaFunc(DeleteHeroes,true)
	end
	SpawnDelayWaiter = 10
	SpawnDelayWaiter2 = 40
end

function DeleteHeroes(self)
	 if self.UACore then
        local id = self.UACore:GetFirstDeadHero()
        while id do
            DestroyEntity(id)
            id = self.UACore:GetFirstDeadHero()
        end
    else
        for i = table.getn(self.DeadHeroes),1,-1 do
            DestroyEntity(self.DeadHeroes[i])
        end
    end
	return true
end

function PureRandom()
	time = Framework.GetSystemTimeDateString()
	local shrink = function(cc)
        local o, i = {}, 1
        for n = 1, string.len(cc) do
            local b = string.byte(cc, n)
            n=n+1
            o[i] = b; 
			i = i + 1
        end
        return table.concat(o)
    end
	return math.mod(math.mod(tonumber(shrink(time)),2^15)* XGUIEng.GetSystemTime(),2^15)
end

function StartGame()
	XGUIEng.ShowWidget("Movie",0)
	
	XGUIEng.ShowWidget("MainMenuWindow_SaveGame",1)
	XGUIEng.ShowWidget("MainMenuWindow_SaveGameOverlay",1)
	Input.KeyBindDown(Keys.F6,"QuickSave()", 2 )
	
	InitTimer()
	
end

function InitTimer()
	Logic.DestroyEntity(VisionID)
	XGUIEng.ShowWidget("GameClock",1)
	XGUIEng.SetMaterialColor(gvGUI_WidgetID.GameClock, 0, 0, 0, 0, 0)
	XGUIEng.SetWidgetPositionAndSize(gvGUI_WidgetID.GameClock, 470, 374, 84, 20)
	XGUIEng.SetTextColor(gvGUI_WidgetID.GameClock, 0, 128, 0)
	DoorTimer = 10
	function GUIUpdate_Clock()
		XGUIEng.SetText(gvGUI_WidgetID.GameClock, "@center "..DoorTimer)
	end
	StartSimpleJob("TimerCountdown")
end

function TimerCountdown()
	if DoorTimer == 0 then
		--Welle 1 Start
		--f(x) = 0.000058x^3 + 0.074032x^2 + 0.718119x
		
		--f(x) = 0.0000058x^3 + 0.0074032x^2 + 0.318119x
		Sound.PlayGUISound(Sounds.fanfare, 50);
		Logic.SetEntitySelectableFlag(GetID("player1"), 1)
		Logic.SetEntitySelectableFlag(GetID("player1DZ"), 1)
		wavecounter = 359
		ChangeClock()
		AddSaveLoadedCallback(ChangeClock)
		ArmyCounter = 0
		funcvalue = 0
		StartSimpleJob("WaveCounterFunc")
		StartSimpleHiResJob("SpawnDelayLimiter")
		SpawnDelayTable = {}
		return true
	end
	DoorTimer = DoorTimer - 1
	if DoorTimer > 8 then
		XGUIEng.SetTextColor(gvGUI_WidgetID.GameClock, 0, 128, 0)
	elseif DoorTimer > 6 then
		XGUIEng.SetTextColor(gvGUI_WidgetID.GameClock, 0, 255, 0)
	elseif DoorTimer > 4 then
		XGUIEng.SetTextColor(gvGUI_WidgetID.GameClock, 255, 255, 0)
	elseif DoorTimer > 2 then
		XGUIEng.SetTextColor(gvGUI_WidgetID.GameClock, 255, 128, 0)
	else
		XGUIEng.SetTextColor(gvGUI_WidgetID.GameClock, 255, 0, 0)
	end
	return false
end

function SpawnDelayLimiter()
	local numberOfEntries = table.getn(SpawnDelayTable)
	if numberOfEntries <= 0 then
	return false
	end
	if numberOfEntries ~=0 and SpawnDelayTable[1][1] <= 0 then
		table.remove(SpawnDelayTable,1)
		return false
	end
	if SpawnDelayWaiter2 < 40 then
		SpawnDelayWaiter2 = SpawnDelayWaiter2 - 1
		return false
	end
	local insTroops = 0
	for i=1,40,1 do
		insTroops = insTroops + UAArmies[i]:GetSize(true,true)
		if insTroops > 65 then
			SpawnDelayWaiter = 0
			return false
		end
	end
	ArmyCounter = ArmyCounter + 1
	if ArmyCounter >= 41 then
		ArmyCounter = 1
	end
	SpawnTable[SpawnDelayTable[1][2]].SpawnFunc(ArmyCounter)
	SpawnDelayTable[1][1] = SpawnDelayTable[1][1] - 1
	return false
end

function SpawnLimiter(_ueberschuss,difficulty)
	table.insert(SpawnDelayTable,{_ueberschuss,difficulty})
end

function WaveCounterFunc()
	if SpawnDelayWaiter < 10 then
		SpawnDelayWaiter = SpawnDelayWaiter + 1
		return false
	end
	local spawnlimit = 0
	for i = 1,40,1 do
		 spawnlimit = spawnlimit + UAArmies[i]:GetSize(true,false)
		 if spawnlimit + (table.getn(SpawnDelayTable) > 0 and SpawnDelayTable[1][1] or 0) >= 45 then
			SpawnDelayWaiter = 0
			return false
		end
	end
	wavecounter = wavecounter + 1
	if math.mod(wavecounter,currentWaveLimit) == 0 then
		if wavecounter <= 2800 then
			funcvalue =  Round(0.0000058*2*(wavecounter/currentWaveLimit)^3 + 0.0074032*2*(wavecounter/currentWaveLimit)^2 + 0.318119*2*(wavecounter/currentWaveLimit))
		else
			funcvalue =  Round(((wavecounter/currentWaveLimit)^1.1)-(44/(wavecounter/currentWaveLimit)))
		end
		local dif = GetWaveLevel(wavecounter)
		if not SpawnTable[dif].Techsforsched then
			for k,v in pairs(SpawnTable[dif].Techs) do
				Logic.SetTechnologyState(2,v,3)
			end
			SpawnTable[dif].Techsforsched = true
		end
		if funcvalue > 20 then
			SpawnLimiter(funcvalue,dif)
		else
		for i = 1, funcvalue,1 do
			ArmyCounter = ArmyCounter + 1
			if ArmyCounter >= 41 then
				ArmyCounter = 1
			end
			--spawnen
			SpawnTable[dif].SpawnFunc(ArmyCounter)
		end
		end
	end
	return false
end

function Round( _n )
	return math.floor( _n + 0.5 );
end

function controlBombs()
	for i = table.getn(bombers),1,-1 do
		if IsDead(bombers[i]) then
			local deadtroop = table.remove(bombers,i)
		end
		if not deadtroop and GetRandom(100) > 50 then
			CreateEntity(2,Entities.XD_Bomb1,GetPosition(bombers[i]),"bang")
		end
	end
   return false
end

function GetWaveLevel(timedone)
	if timedone < 900*2 then
		return 1
	elseif timedone < 1500*2 then
		return 2
	elseif timedone < 2400*2 then
		return 3
	elseif timedone < 3600*2 then
		return 4
	else
		return 5
	end
	return
end

function getRndPoint()
    local center = {X=32000,Y=32000}
    local myPoint = getRandomPointOnCircle( center.X, center.Y, 31500)
	--LuaDebugger.Log(myPoint)
    return myPoint
end

function getRandomPointOnCircle( _centerX, _centerY, _r)
    local randAngle = 2*math.pi*math.random()
    return {X = _centerX + _r*math.cos(randAngle), Y = _centerY + _r*math.sin(randAngle)}
end

function Round( _n )
	return math.floor( _n + 0.5 );
end

function ChangeClock()
		XGUIEng.SetWidgetPositionAndSize(gvGUI_WidgetID.GameClock, 470, 73, 84, 20)
		XGUIEng.SetMaterialColor(gvGUI_WidgetID.GameClock, 0,36, 39, 36, 109)
		XGUIEng.SetTextColor(gvGUI_WidgetID.GameClock, 255, 0, 0)
		function GUIUpdate_Clock()
			XGUIEng.SetText(gvGUI_WidgetID.GameClock, "@center Welle "..(math.floor(wavecounter/currentWaveLimit)-1))
		end
		XGUIEng.ShowWidget("StopWatch",1)
	
		XGUIEng.SetWidgetPositionAndSize("StopWatch", 0, 0, 100, 30)
		
		
end

MinesTable = {[Entities.XD_ClayPit1] = true,
			[Entities.XD_StonePit1] = true,
			[Entities.XD_SulfurPit1] = true,
			[Entities.XD_IronPit1] = true,
			[Entities.XD_ClosedClayPit1] = true,
			[Entities.XD_ClosedStonePit1] = true,
			[Entities.XD_ClosedIronPit1] = true,
			[Entities.XD_ClosedSulfurPit1] = true
			}
MineResourceTable = {}

function ShuffleMines()
	local name
	local allMines = getMines()
	local MinePos
	local doodAmount
	local mineID 
	local partname
	verschuettetePos = nil
	verschuettetRes = nil
	for w,v in pairs(allMines) do
		name = Logic.GetEntityTypeName(Logic.GetEntityType(v))
		if math.random(1,2) == 2 then --schließen
			if not string.find(name,"Closed") then -- wenn offen
				MinePos = GetPosition(v)
				doodAmount = Logic.GetResourceDoodadGoodAmount(v)
				partname = string.sub(name,4)
				Logic.DestroyEntity(v)
				mineID = Logic.CreateEntity(_G["Entities"]["XD_Closed"..partname], MinePos.X, MinePos.Y, 0, 0)
				if not MineResourceTable[MinePos.X] then
					MineResourceTable[MinePos.X] = {}
				end
				MineResourceTable[MinePos.X][MinePos.Y] = doodAmount
			else
				MinePos = GetPosition(v)
				if not MineResourceTable[MinePos.X] then
					MineResourceTable[MinePos.X] = {}
				end
				MineResourceTable[MinePos.X][MinePos.Y] = 12000
			end
		else --oeffnen
			if string.find(name,"Closed") then
				MinePos = GetPosition(v)
				_,partname = string.gsub(name,"Closed","")
				Logic.DestroyEntity(v)
				Logic.CreateEntity(_G["Entities"][partname], MinePos.X, MinePos.Y, 0, 0)
			end
		end
	end
	MineFuellerJob = Trigger.RequestTrigger(Events.LOGIC_EVENT_ENTITY_CREATED,nil,"FillMine",1,nil,nil)
end

function FillMine()
	local _ent = Event.GetEntityID()
	if MinesTable[Logic.GetEntityType(_ent)] then
		local _pos = GetPosition(_ent)
		Logic.SetResourceDoodadGoodAmount(_ent, MineResourceTable[_pos.X][_pos.Y])
	end
end

function getMines()
	local _table = {}
	for v,_ in pairs(MinesTable) do
		local mines = {Logic.GetEntities(v,16)}
		for i=2,table.getn(mines),1 do
			table.insert(_table,mines[i])
		end
	end
	return _table
end