-------------------------------------------------------------------------------------------------------------------------
--
--									Quest:	Destroy Outpost
--
-------------------------------------------------------------------------------------------------------------------------

startQuestDestroyOutpost = function()

	Report("start quest: destroy outpost")

	--	ai
	
		createArmyAttack1()

		createArmyAttack2()
		
		createArmyMinePatrol()

		createArmyDefendMines()

	--	quest
	
		createDoorQuest()

		createQuestReachWeatherMachine()
		createQuestWeatherMaker()
		
		createQuestDefeat()
		
		createQuestDestroyOutpost()
		
		createQuestTrader1()
		createQuestTrader2()
		createQuestTrader3()
	
		createQuestReinforcements()
		
		createQuestWetCannons()

		createQuestRewards()

	-- NPCs

		InitMapNPCs()

		InitNPCLookAt("Miner1")
	

	--	briefing

		createBriefingPrelude()

	end

-------------------------------------------------------------------------------------------------------------------------
	
endQuestDestroyOutpost = function()

	--createQuestDestroyLionsDen() ist in quest_CollectHeroes.lua
	createQuestCollectHeroes()
	
	local wallnumbers,wallentID = Logic.GetPlayerEntitiesInArea(3,0,outpostpos.X,outpostpos.Y,5000,1)
	while wallnumbers > 0 do
		Logic.ChangeEntityPlayerID(wallentID, 4)
		wallnumbers,wallentID = Logic.GetPlayerEntitiesInArea(3,0,outpostpos.X,outpostpos.Y,5000,1)
	end

	--startQuestDestroyLionsDen() ist in quest_CollectHeroes.lua

	ResolveBriefing(briefingPrelude[page_preludeOutpost])

	end

-------------------------------------------------------------------------------------------------------------------------
--
--									Quest:	Destroy Lions Den
--
-------------------------------------------------------------------------------------------------------------------------

startQuestDestroyLionsDen = function()

	Report("start quest: destroy lions den")

		createQuestReinforcements2()

	--	ai
	
		createArmyDefendDen()
	
		createArmyAttack3()
		
		Logic.SetDiplomacyState( 1, 5, Diplomacy.Hostile )
		Logic.SetPlayerName(5, String.MainKey.."_Player5Name")

	end

-------------------------------------------------------------------------------------------------------------------------
	
endQuestDestroyLionsDen = function()

	ResolveBriefing(briefingPrelude[page_preludeCastle])

	-- start Kerberos' history fresco
		StartBinkVideo("BattleOfEvelance") 

	-- Extro
		StartBinkVideo("Outro")

	Victory()

end

function endQuestDestroyLionsDenAdvanced()
	ResolveBriefing(briefingPrelude[page_preludeCastle])
	
	StartCutscene("FinalView", startQuestFinalBattle)
	
	
end

function startQuestFinalBattle()
	startBriefingEndFight()
end	

function EndFightEnd()
	FinalRoomUADef:Destroy()
	FinalRoomUAAttack:Destroy()
	bossdownpos = GetPosition("FinalBase")
	finalbaseexplodecounter = 0
	StartSimpleHiResJob("FinalBaseExplode")
end

function FinalBaseExplode()
	if finalbaseexplodecounter >= 51 then
		-- start Kerberos' history fresco
		StartBinkVideo("BattleOfEvelance") 
		--Extro
		StartBinkVideo("Outro")

		Victory()

		return true
	end
	RandomFuncInArea("FinalBase",2000,function(p) Logic.CreateEffect(GGL_Effects.FXExplosionPilgrim,p.X,p.Y,0) end)
	finalbaseexplodecounter = finalbaseexplodecounter + 1
	return false 
end
-------------------------------------------------------------------------------------------------------------------------
--
--									GameCallback_NPCInteraction
--
-------------------------------------------------------------------------------------------------------------------------
	
GameCallback_NPCInteraction = function(_heroId,_npcId)

	-- Ignore if running briefing
	if IsBriefingActive() then
		return
	end

	if Logic.IsHero(_heroId) then
	
		if _npcId == GetEntityId("trader1") then

			if IsNear(_heroId,_npcId,BRIEFING_TALK_DISTANCE) then
			
				createBriefingTrader1()
			
				destroyQuestTrader1()
				
			end
	
		end

		if _npcId == GetEntityId("trader2") then

			if IsNear(_heroId,_npcId,BRIEFING_TALK_DISTANCE) then
			
				createBriefingTrader2()
			
				destroyQuestTrader2()
				
			end
	
		end

		if _npcId == GetEntityId("trader3") then

			if IsNear(_heroId,_npcId,BRIEFING_TALK_DISTANCE) then
			
				createBriefingTrader3()
			
				destroyQuestTrader3()
				
			end
	
		end

	
		if _npcId == GetEntityId("WeatherMaker") then

			if IsNear(_heroId,_npcId,BRIEFING_TALK_DISTANCE) then
			
				createBriefingWeatherMaker()
			
				destroyQuestWeatherMaker()
				
			end
	
		end
	

	-- NPCs giving hints:

    
	    local NPC = "Miner1"
	    if _npcId == GetEntityId(NPC) then
	
			if IsNear(_heroId,_npcId,BRIEFING_TALK_DISTANCE) then
			
				createBriefingMiner1()
				DisableNpcMarker(NPC)
				
			end
		end


	----------------------------------------------------------------------------------------
	--	Tipp-giving NPCs without quests; TF_include

		MapLocal_npcCheck(_heroId,_npcId)

	----------------------------------------------------------------------------------------

	end
end