createArmyAttack2 = function()
	-- PlayerAttackUA via land
	PlayerLandAttackUA = UnlimitedArmy:New({
				Player = 4,
				Area = 4000,
				TransitAttackMove = true,
				Formation = UnlimitedArmy.Formations.Chaotic,
				LeaderFormation = FormationFunktion,
				AIActive = true,
				AutoRotateRange = true,
				DoNotNormalizeSpeed = false,
				})
	local landpos = GetPosition("FirstAttackSpawn2")
	PlayerLandAttackUA:CreateLeaderForArmy(Entities.PU_LeaderHeavyCavalry2,3,landpos,0)
	PlayerLandAttackUA:CreateLeaderForArmy(Entities.PU_LeaderHeavyCavalry2,3,landpos,0)
	PlayerLandAttackUA:CreateLeaderForArmy(Entities.PU_LeaderHeavyCavalry2,3,landpos,0)
	PlayerLandAttackUA:CreateLeaderForArmy(Entities.PU_LeaderHeavyCavalry2,3,landpos,0)
	PlayerLandAttackUA:CreateLeaderForArmy(Entities.PU_LeaderHeavyCavalry2,3,landpos,0)
	PlayerLandAttackUA:CreateLeaderForArmy(Entities.PU_LeaderHeavyCavalry2,3,landpos,0)
	PlayerLandAttackUA:CreateLeaderForArmy(Entities.PU_LeaderCavalry2,3,landpos,0)
	PlayerLandAttackUA:CreateLeaderForArmy(Entities.PU_LeaderCavalry2,3,landpos,0)
	PlayerLandAttackUA:CreateLeaderForArmy(Entities.PU_LeaderCavalry2,3,landpos,0)
	PlayerLandAttackUA:CreateLeaderForArmy(Entities.PU_LeaderCavalry2,3,landpos,0)
	PlayerLandAttackUA:CreateLeaderForArmy(Entities.PU_LeaderCavalry2,3,landpos,0)
	PlayerLandAttackUA:CreateLeaderForArmy(Entities.PU_LeaderCavalry2,3,landpos,0)
	PlayerLandAttackUA:CreateLeaderForArmy(Entities.PV_Cannon3,0,landpos,0)
	PlayerLandAttackUA:CreateLeaderForArmy(Entities.PV_Cannon3,0,landpos,0)
	PlayerLandAttackUA:CreateLeaderForArmy(Entities.PV_Cannon4,0,landpos,0)
	PlayerLandAttackUA:CreateLeaderForArmy(Entities.PV_Cannon4,0,landpos,0)
end

function StartWaver2(self)
	if self:GetSize(true,false) == 0 then
		StartSimpleJob("FirstWaveDone")
		return true
	end
	return false
end

function FirstWaveDone()
	if PlayerLandAttackUA:GetSize(true,false) == 0 then
		if PlayerWaterAttackUA:GetSize(true,false) == 0 then
			WaveCounter = 300
			PlayerLandAttackUA.DoNotNormalizeSpeed = true
			PlayerWaterAttackUA.DoNotNormalizeSpeed = true
			Trigger.RequestTrigger(Events.LOGIC_EVENT_ENTITY_CREATED, nil, "checkifenemycannon",1,nil,nil)
			StartSimpleJob("CounterToNextWaves")
			return true
		end
	end
	return false
end

function checkifenemycannon()
	local entityID = Event.GetEntityID()
	if Logic.GetDiplomacyState(1, Logic.EntityGetPlayer(entityID)) == Diplomacy.Hostile then
		local ety = Logic.GetEntityType(entityID)
		if ety == Entities.PV_Cannon1 then
			Logic.SetSpeedFactor(entityID, 340/240)
			return false
		elseif ety == Entities.PV_Cannon2 then
			Logic.SetSpeedFactor(entityID, 340/260)
			return false
		elseif ety == Entities.PV_Cannon3 then
			Logic.SetSpeedFactor(entityID, 340/220)
			return false
		elseif ety == Entities.PV_Cannon4 then
			Logic.SetSpeedFactor(entityID, 340/180)
			return false
		end
	end
	return false
end

function CounterToNextWaves()
	if WaveCounter == 0 then
		PlayerLandAttackUASpawnGenerator = UnlimitedArmySpawnGenerator:New(PlayerLandAttackUA,{
									Position = GetPosition("army1"),
									ArmySize = 15,
									SpawnCounter = 1,
									SpawnLeaders = 15,
									LeaderDesc = {
										{LeaderType = Entities.PU_LeaderHeavyCavalry2, SoldierNum = 3, SpawnNum = 5, Looped = true, Experience = 3},
										{LeaderType = Entities.PU_LeaderCavalry2, SoldierNum = 3, SpawnNum = 5, Looped = true, Experience = 3},
										{LeaderType = Entities.PV_Cannon4, SoldierNum = 0, SpawnNum = 1, Looped = true, Experience = 3},
										{LeaderType = Entities.PV_Cannon3, SoldierNum = 0, SpawnNum = 1, Looped = true, Experience = 3},
										},
										Generator = "outpost"
										})
		PlayerLandAttackUA:AddCommandMove(GetPosition("army1"),true)
		PlayerLandAttackUA:AddCommandWaitForSpawnerFull(true)
		PlayerLandAttackUA:AddCommandSetSpawnerStatus(false,true)
		PlayerLandAttackUA:AddCommandMove(GetPosition("defendMines"),true)
		PlayerLandAttackUA:AddCommandWaitForIdle(true)
		PlayerLandAttackUA:AddCommandMove(GetPosition("traderDeployEnd3"),true)
		PlayerLandAttackUA:AddCommandWaitForIdle(true)
		PlayerLandAttackUA:AddCommandMove(GetPosition("waypointX"),true)
		PlayerLandAttackUA:AddCommandWaitForIdle(true)
		PlayerLandAttackUA:AddCommandMove(GetPosition("FirstAttackSpawn2"),true)
		PlayerLandAttackUA:AddCommandWaitForIdle(true)
		PlayerLandAttackUA:AddCommandLuaFunc(Militarybasedown,true)
		PlayerLandAttackUA:AddCommandLuaFunc(IdleWaiterfunc,true)
		PlayerLandAttackUA:AddCommandWaitForIdle(true)
		PlayerLandAttackUA:AddCommandWaitForTroopSize(1, true, true)
		PlayerLandAttackUA:AddCommandLuaFunc(AddSuperLeader,true)
		--Func armysize hoeher?
		PlayerLandAttackUA:AddCommandSetSpawnerStatus(true,true)
		
		PlayerWaterAttackUASpawnGenerator = UnlimitedArmySpawnGenerator:New(PlayerWaterAttackUA,{
									Position = GetPosition("army1"),
									ArmySize = 15,
									SpawnCounter = 1,
									SpawnLeaders = 15,
									LeaderDesc = {
										{LeaderType = Entities.PU_LeaderSword4, SoldierNum = 8, SpawnNum = 3, Looped = true, Experience = 3},
										{LeaderType = Entities.PU_LeaderPoleArm4, SoldierNum = 8, SpawnNum = 3, Looped = true, Experience = 3},
										{LeaderType = Entities.PU_LeaderBow4, SoldierNum = 8, SpawnNum = 4, Looped = true, Experience = 3},
										{LeaderType = Entities.PV_Cannon4, SoldierNum = 0, SpawnNum = 2, Looped = true, Experience = 3},
										{LeaderType = Entities.PV_Cannon3, SoldierNum = 0, SpawnNum = 1, Looped = true, Experience = 3}
										},
										Generator = "outpost"
										})
		PlayerWaterAttackUA:AddCommandMove(GetPosition("army1"), true)
		PlayerWaterAttackUA:AddCommandWaitForSpawnerFull(true)
		PlayerWaterAttackUA:AddCommandSetSpawnerStatus(false,true)
		PlayerWaterAttackUA:AddCommandWaitForIdle(true)
		PlayerWaterAttackUA:AddCommandMove(GetPosition("IceAttack3"),true)
		PlayerWaterAttackUA:AddCommandWaitForIdle(true)
		PlayerWaterAttackUA:AddCommandLuaFunc(WinterAttackerDecider, true)
		PlayerWaterAttackUA:AddCommandLuaFunc(WinterAttackerToMines, true)
		PlayerWaterAttackUA:AddCommandLuaFunc(WinterAttackerToTraders,true)
		PlayerWaterAttackUA:AddCommandLuaFunc(WinterAttackerToWaypointX,true)
		PlayerWaterAttackUA:AddCommandLuaFunc(WinterAttackerToFirstAttackSpawn2,true)
		PlayerWaterAttackUA:AddCommandLuaFunc(WinterAttackerToMilitarybase,true)
		PlayerWaterAttackUA:AddCommandLuaFunc(IdleWaiterfunc,true)
		PlayerWaterAttackUA:AddCommandWaitForIdle(true)
		PlayerWaterAttackUA:AddCommandWaitForTroopSize(1,true,true)
		PlayerWaterAttackUA:AddCommandLuaFunc(AddSuperLeader,true)
		PlayerWaterAttackUA:AddCommandSetSpawnerStatus(true,true)
		return true
	end
	WaveCounter = WaveCounter - 1
	return false
end

function IdleWaiterfunc(self)
	if self:IsIdle() then
		return true
	end
		if (GetDistance(self:GetPosition(),"UAcheckmoving1") <= 1200) or (GetDistance(self:GetPosition(),"UAcheckmoving2") <= 1300) then
			self:CheckValidArmy()
			if Logic.IsLeader(self.Leaders[1]) == 1 then
				local soldiers = {Logic.GetSoldiersAttachedToLeader(self.Leaders[1])}
				table.remove(soldiers, 1)
				for _,v in ipairs(soldiers) do
					SetHealth(v, 0)
				end
			end
			SetHealth(self.Leaders[1], 0)
		end
	return false
end

function Militarybasedown(self)
	if self:GetSize(true,false) == 0 then
		return true
	end
	if self:IsIdle() then
		if IsAlive("targetX") or IsAlive("castle") then
			if IsAlive("targetX") then
				return false, UnlimitedArmy.CreateCommandMove(GetPosition("targetX"))
			else
				return false, UnlimitedArmy.CreateCommandMove(GetPosition("castle"))
			end
		else
			return true, UnlimitedArmy.CreateCommandMove(GetPosition("castle1"))
		end
	else
		return false
	end
end

function AddSuperLeader(self)
	if IsAlive("outpost") then
		self:CreateLeaderForArmy(Entities.PU_LeaderSword1, 0, GetPosition("army1"), 3)
	end
	return true
end

function WinterAttackerDecider(self)
	if self:IsIdle() then
		if Logic.GetWeatherState() == 3 then
			self.Wegweisser = 0
			return true, UnlimitedArmy.CreateCommandLuaFunc(Militarybasedown)
		else
			self.Wegweisser = 1
			return true, UnlimitedArmy.CreateCommandMove(GetPosition("defendMines"))
		end
	end
	return false
end

function WinterAttackerToMines(self)
	if self.Wegweisser == 0 then
		return true
	end
	if self:IsIdle() then
		return true, UnlimitedArmy.CreateCommandMove(GetPosition("traderDeployEnd3"))
	end
	return false
end

function WinterAttackerToTraders(self)
	if self.Wegweisser == 0 then
		return true
	end
	if self:IsIdle() then
		return true, UnlimitedArmy.CreateCommandMove(GetPosition("waypointX"))
	end
	return false
end

function WinterAttackerToWaypointX(self)
	if self.Wegweisser == 0 then
		return true
	end
	if self:IsIdle() then
		return true, UnlimitedArmy.CreateCommandMove(GetPosition("FirstAttackSpawn2"))
	end
	return false
end

function WinterAttackerToFirstAttackSpawn2(self)
	if self.Wegweisser == 0 then
		return true
	end
	if self:IsIdle() then
		return true, UnlimitedArmy.CreateCommandMove(GetPosition("FirstAttackSpawn2"))
	end
	return false
end

function WinterAttackerToMilitarybase(self)
	if self:IsIdle() then
		return true, UnlimitedArmy.CreateCommandLuaFunc(Militarybasedown)
	end
	return false
end