function Rasterung(RasterDif)
	local TabellenString = "WorldTable = {}\n"
	local WorldSizeX, WorldSizeY = Logic.WorldGetSize()
	local x,y = 0,0
	local xpos,ypos,zpos
	local Rastergenauigkeit = RasterDif
	local WorldTable = {}
	local placeID
	
	while x <= WorldSizeX do
		while y <= WorldSizeY do
			placeID = Logic.CreateEntity(Entities.XD_ScriptEntity, x, y, 0, 1)
			xpos,ypos,zpos = Logic.EntityGetPos(placeID)
			if WorldTable[xpos] == nil then
				WorldTable[xpos] = {}
				TabellenString = TabellenString.."WorldTable["..xpos.."] = {}\n"
			end
			WorldTable[xpos][ypos] = zpos
			TabellenString = TabellenString.."WorldTable["..xpos.."]["..ypos.."] = "..zpos.."\n"
			Logic.DestroyEntity(placeID)
			y = y + Rastergenauigkeit
		end
		x = x + Rastergenauigkeit
		y = 0
	end
	
	LuaDebugger.Log(TabellenString)
end

function interpol( _delX, _delY, _node00, _node01, _node10, _node11)
    local int1 = _node00 + _delX * (_node01 - _node00)
    local int2 = _node10 + _delX * (_node11 - _node10)
    return _delY*(int2 - int1) + int1
end

function getZ( _x, _y,rastereinheit)
	local gridSize = rastereinheit
    local xMod = math.mod(_x, gridSize)
    local xIndex = _x - xMod
    local yMod = math.mod(_y, gridSize)
    local yIndex = _y - yMod
    return interpol( xMod/gridSize, yMod/gridSize, WorldTable[xIndex][yIndex], WorldTable[xIndex+gridSize][yIndex], WorldTable[xIndex][yIndex+gridSize], WorldTable[xIndex+gridSize][yIndex+gridSize])
end