-- at small Castle in NorthEast; end-boss defenders

setupArmyDespair = function()
local spawnpos = {}
spawnpos[1] = GetPosition("despairoutsidespawn") 
spawnpos[1].Generator = {"despairoutsidebuilding2", "despairoutsidebuilding1"}
spawnpos[2] = GetPosition("DespairSpawn")
spawnpos[2].Generator = "DespairHQ"
StartSimpleJob("HauptmannMinibosscheck")
armychecktable1 = {}
StartSimpleJob("Check_ArmySoldiers1")
UnlimitedArmyDespair = UnlimitedArmy.New({
							Player = 5,
							Area = 7500,
							AutoDestroyIfEmpty = false,
							TransitAttackMove = true,
							Formation = UnlimitedArmy.Formations.Lines,
							LeaderFormation = 4,
							AIActive = true,
							AutoRotateRange = true,
							DoNotNormalizeSpeed = true,
							})
UnlimitedArmyDespairSpawnGenerator = UnlimitedArmySpawnGenerator.New(UnlimitedArmyDespair, {
									Position = spawnpos,
									ArmySize = 18,
									SpawnCounter = 15,
									SpawnLeaders = 18,
									LeaderDesc = {
												{LeaderType = Entities.PU_LeaderSword4, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
												{LeaderType = Entities.PU_LeaderBow4, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
												{LeaderType = Entities.PV_Cannon3, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
												{LeaderType = Entities.PU_LeaderCavalry2, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
												{LeaderType = Entities.PU_LeaderPoleArm4, SoldierNum = 8, SpawnNum = 4, Looped = true, Experience = 3},
												{LeaderType = Entities.PU_LeaderBow4, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
												{LeaderType = Entities.PV_Cannon4, SoldierNum = 8, SpawnNum = 1, Looped = true, Experience = 3},
													},
									})
UnlimitedArmyDespair:AddCommandMove(GetPosition("DespairArmyCollecting"),true)
UnlimitedArmyDespair:AddCommandWaitForIdle(true)
UnlimitedArmyDespair:AddCommandWaitForTroopSize(18, true, true)
UnlimitedArmyDespair:AddCommandWaitForTroopSize(18, false,true)

end

HauptmannMinibosscheck = function()
local p = GetPosition("HauptmannMiniBoss")
local anzahl, id1 = Logic.GetPlayerEntitiesInArea(GetHumanPlayer(),0,p.X,p.Y,1000,1)
if anzahl == 1 then
Logic.SetTechnologyState(5,Technologies.T_SuperTechnology,3)
bossId = AI.Entity_CreateFormation(5, Entities.PU_LeaderSword1, nil, 0, GetPosition("DespairSpawn").X, GetPosition("DespairSpawn").Y, nil, nil, 4, 0)
Logic.SetEntityName(bossId, "EvelanceBossP5")
UnlimitedArmyDespair:AddLeader(bossId)
--UnlimitedArmyDespair:CreateLeaderForArmy(Entities.PU_LeaderSword1, 0, GetPosition("DespairSpawn"),4)
return true
end
return false
end

Check_ArmySoldiers1 = function ()
     for hochzahl,id in ipairs(UnlimitedArmyDespair.Leaders) do
        if Logic.LeaderGetNumberOfSoldiers(id)<1 and Logic.LeaderGetMaxNumberOfSoldiers(id)>0 and not Table_Check1(armychecktable1, id) then
            if id ~= Logic.GetEntityIDByName("EvelanceBossP5") then
                table.insert(armychecktable1, 1, {id,15})
                --armychecktable1[hochzahl] = {id, 20}
            end
        end
    end
	if table.getn(armychecktable1) < 1 then
		return false
	else
		for ccounter = table.getn(armychecktable1), 1,-1 do
			if armychecktable1[ccounter][2] == 0 then
				if IsValid(armychecktable1[ccounter][1]) then
				SetHealth(armychecktable1[ccounter][1],0)
				end 
				table.remove(armychecktable1, ccounter)
			else
				armychecktable1[ccounter][2] = armychecktable1[ccounter][2] - 1
			end
		end
	end
	return false
end

Table_Check1 = function(tableinsert,ida)
for k,tableinsertis in ipairs(tableinsert) do
    if tableinsertis[1] == ida then
      return true
    end
  end
  return false
end