setupArmyRobbers = function()

	ArmyRobbers1 = {}
	ArmyRobbers2 = {}
	ArmyRobbers3 = {}
	ArmyRobbers4 = {}

	createRobbers(ArmyRobbers1, 3, 1, 500)
	createRobbers(ArmyRobbers2, 3, 2, 10)
	createRobbers(ArmyRobbers3, 3, 3, 500)
	createRobbers(ArmyRobbers4, 8, 4, 500)

	StartJob("ControlArmyRobbers")
end

createRobbers = function(_army, _strength, _index, _defenseRange)

	-- Create robbers
	_army.player 			= 3
	_army.id				= _index
	_army.strength			= _strength
	_army.position			= GetPosition("Robbers".._index)
	_army.rodeLength		= _defenseRange
	
	-- Spawn parameter
	_army.spawnTypes 		= { {Entities.CU_BanditLeaderSword1, 12} }
									
	_army.spawnPos			= GetPosition("Robbers".._index)
	_army.spawnGenerator	= "RobberTower".._index
	_army.respawnTime		= 120
	_army.maxSpawnAmount	= 1
	_army.endless			= true
	_army.refresh			= false

	_army.retreatStrength	= 0
	_army.baseDefenseRange	= _defenseRange
	_army.outerDefenseRange	= _defenseRange
	_army.Attack			= false
	_army.AttackAllowed		= false

	-- Setup army
	SetupArmy(_army)
	
	-- Army generator
	SetupAITroopSpawnGenerator("Robbers".._index, _army)

end

-----------------------------------------------------------------------------------------------------------------------
--
--	JOB: "ControlArmyAI2"
--
-----------------------------------------------------------------------------------------------------------------------	
	-------------------------------------------------------------------------------------------------------------------
	Condition_ControlArmyRobbers = function()
	-------------------------------------------------------------------------------------------------------------------
		return Counter.Tick2("ControlArmyRobbers",10)
	end
		
	-------------------------------------------------------------------------------------------------------------------
	Action_ControlArmyRobbers = function()
	-------------------------------------------------------------------------------------------------------------------
		TickOffensiveAIController(ArmyRobbers1)
		TickOffensiveAIController(ArmyRobbers2)
		TickOffensiveAIController(ArmyRobbers3)
		TickOffensiveAIController(ArmyRobbers4)
		return false		
	end
-----------------------------------------------------------------------------------------------------------------------
