--------------------------------------------------------------------------------
-- MapName: Old Kings Castle
--
-- urspruenglicher Author: Peter Sprys
-- schwere Version: schmeling65
--------------------------------------------------------------------------------

	Input.KeyBindDown (Keys.NumPad7, "Cheat_Intro_Start()")


-- Include main function
Script.Load( Folders.MapTools.."Main.lua" )

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called from main script to initialize the diplomacy states
function Mission_InitDiplomacy()
	Logic.SetDiplomacyState( 1, 2, Diplomacy.Hostile )
	Logic.SetDiplomacyState( 1, 3, Diplomacy.Hostile )
	Logic.SetDiplomacyState( 1, 5, Diplomacy.Hostile )
end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called to set the player colors
function Mission_InitPlayerColorMapping()

	Display.SetPlayerColorMapping(2, KERBEROS_COLOR)		-- Kerberos in Southwest
	Display.SetPlayerColorMapping(3, ROBBERS_COLOR)			-- Robbers at Mountain path
	Display.SetPlayerColorMapping(4, PLAYER_FRIEND_COLOR)	-- Garek, village
	Display.SetPlayerColorMapping(5, KERBEROS_COLOR)		-- Kerberos in northeast
	Display.SetPlayerColorMapping(6, FRIENDLY_COLOR2)		-- Avala (Mountain village)
	Display.SetPlayerColorMapping(7, NPC_COLOR)				-- NPCs
	
end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called from main script to init all resources for player(s)
function Mission_InitResources()

end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called to setup Technology states on mission start
function Mission_InitTechnologies()

end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start to initialize ai for all ai players
function Mission_InitAI()
end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start and after save game is loaded, setup your weather gfx
-- sets here
function Mission_InitWeatherGfxSets()

	Display.SetRenderUseGfxSets(1)
	
	WeatherSets_SetupNormal(1)
	WeatherSets_SetupRain(2)
	WeatherSets_SetupSnow(3)
end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start you should setup your weather periods here
function Mission_InitWeather()

	Logic.AddWeatherElement(2, 5, 1, 2, 5, 10)

end
	
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start after all initialization is done
function Mission_FirstMapAction()

	IncludeLocals("Cutscene_Control")

	-- Load mission files
	IncludeLocals("army_p2defense")
	IncludeLocals("army_p2firstattack")
	IncludeLocals("army_p2intruders")
	IncludeLocals("army_p2ironattack")
	IncludeLocals("army_p2villageattack")
	IncludeLocals("army_p3robbers")
	IncludeLocals("army_p5attack")
	IncludeLocals("army_p5defense")
	IncludeLocals("army_p6attack")

	IncludeLocals("briefing_bergstadt")
	IncludeLocals("briefing_bergstadtattack")
	IncludeLocals("briefing_garek")
	IncludeLocals("briefing_kerberos")
	IncludeLocals("briefing_neutralkerberos")
	IncludeLocals("briefing_prelude")
	IncludeLocals("briefing_sommer")
	IncludeLocals("briefing_closedgate")
	IncludeLocals("briefing_arisfriends")
	IncludeLocals("briefing_ariheliasdead")
	
	IncludeLocals("gameControl")

	IncludeLocals("player_1")
	IncludeLocals("player_2")
	IncludeLocals("player_3")
	IncludeLocals("player_5")
	IncludeLocals("player_6")

	IncludeLocals("quest_arifriends")
	IncludeLocals("quest_buildneariron")
	IncludeLocals("quest_defeat")
	IncludeLocals("quest_defeatkerberos")
	IncludeLocals("quest_reachexit")
	IncludeLocals("quest_rescuevillage")
	IncludeLocals("quest_sommer")
	IncludeLocals("quest_tributebergstadt")
	IncludeLocals("quest_wintergate")
	IncludeLocals("quest_ariheliasdead")
	
	IncludeLocals("CopyTable")
	IncludeLocals("GetAngleBetween")
	IncludeLocals("GetCirclePosition")
	IncludeLocals("GetDistance")
	IncludeLocals("IsEntityOfType")
	IncludeLocals("TriggerFix")
	IncludeLocals("EntityIdChangedHelper")
	IncludeLocals("UnlimitedArmy")
	IncludeLocals("UnlimitedArmyRecruiter")

	IncludeLocals("quest_gatekey")
	IncludeLocals("quest_opengate")
	IncludeLocals("quest_closedgate")
	IncludeLocals("quest_Leonardo")
	IncludeLocals("quest_rewards")
	IncludeLocals("quest_rebuildCastle")
	
	IncludeLocals("Map_LocalInit")		--TF_Include!

	--	chest handling

		CreateChestOpener("Dario")
		CreateChestOpener("Erec")
		CreateChestOpener("Helias")
		CreateChestOpener("Ari")
		CreateChestOpener("Pilgrim")
		CreateChestOpener("Salim")
		
		Score.Player[0] = {buildings=0, all=0}
	
		CreateRandomGoldChests()
		CreateRandomChests()
		Mission_OnSaveGameLoaded_GateKeyLoader = Mission_OnSaveGameLoaded
		Mission_OnSaveGameLoaded = function()
		Mission_OnSaveGameLoaded_GateKeyLoader()
		ChestSetRandom()
		end
		
		StartChestQuest()


	--
	
		String.Init("CM01_15_OldKingsCastle_Txt")

	-- Set Music-Set

		LocalMusic.UseSet = MEDITERANEANMUSIC
		EntityIdChangedHelper.Init()

	-- Start time line

		TimeLine.Start()
	
	-- Start prelude

		StartCutscene("Intro", start1stQuest)


-- DEBUGG

--	EnableDebugging()

--	StartCutscene("MissionComplete")
end
