
-- Raiders from South
-- y = e^(-0.2x+ln(9)) +1

createArmySouthernAssault = function()

armychecktable = {}

SouthernAttackUnlimitedArmy = UnlimitedArmy.New({
							Player = 3,
							Area = 3500,
							AutoDestroyIfEmpty = false,
							TransitAttackMove = true,
							Formation = UnlimitedArmy.Formations.Lines,
							LeaderFormation = 6,
							AIActive = true,
							AutoRotateRange = true,
							DoNotNormalizeSpeed = true
							})
angriffszaehler = 0
SouthernAttackUnlimitedArmyGenerator = UnlimitedArmySpawnGenerator.New(SouthernAttackUnlimitedArmy,{
						Position = GetPosition("KI4_Spawnpoint"),
						ArmySize = 4,
						SpawnCounter = function() return (8.25*(math.exp(1))^(-0.3*angriffszaehler)+ 1.75)*60 end,
						SpawnLeaders = 4,
						LeaderDesc = {
						{LeaderType=Entities.PU_LeaderSword1, SoldierNum=4, SpawnNum=1, Looped=true, Experience=3},
						{LeaderType=Entities.PU_LeaderPoleArm1, SoldierNum=4, SpawnNum=1, Looped=true, Experience=3},
						{LeaderType=Entities.PU_LeaderBow1, SoldierNum=4, SpawnNum=1, Looped=true, Experience=3}
						}
						})
SouthernAttackUnlimitedArmyGenerator:ResetCounter()
StartSimpleJob("Check_ArmySoldiers")
						
SouthernAttackUnlimitedArmy:AddCommandMove(GetPosition("attack1"),true)
SouthernAttackUnlimitedArmy:AddCommandWaitForSpawnerFull(true)
SouthernAttackUnlimitedArmy:AddCommandSetSpawnerStatus(false,true)
SouthernAttackUnlimitedArmy:AddCommandMove(GetPosition("attack1"),true)
SouthernAttackUnlimitedArmy:AddCommandWaitForIdle(true)
SouthernAttackUnlimitedArmy:AddCommandLuaFunc(Wegeentscheider,true)
SouthernAttackUnlimitedArmy:AddCommandWaitForIdle(true)
SouthernAttackUnlimitedArmy:AddCommandMove(GetPosition("HumanCastle"),true)
SouthernAttackUnlimitedArmy:AddCommandAttackNearestTarget(nil,true)
SouthernAttackUnlimitedArmy:AddCommandWaitForTroopSize(1,true,true)
SouthernAttackUnlimitedArmy:AddCommandLuaFunc(Armyanalyizer,true)
SouthernAttackUnlimitedArmy:AddCommandSetSpawnerStatus(true,true)
end

Armyanalyizer = function()
angriffszaehler = angriffszaehler + 1
if math.mod(angriffszaehler,2) == 0 then
SouthernAttackUnlimitedArmyGenerator.SpawnLeaders = SouthernAttackUnlimitedArmyGenerator.SpawnLeaders + 1
SouthernAttackUnlimitedArmyGenerator.ArmySize = SouthernAttackUnlimitedArmyGenerator.ArmySize + 1
end
if (angriffszaehler + 1) / 4 == 0.5 then
SouthernAttackUnlimitedArmyGenerator:AddLeaderType(Entities.PV_Cannon1, 0, 1, 0, true)
SouthernAttackUnlimitedArmyGenerator:AddLeaderType(Entities.PV_Cannon2, 0, 1, 0, true)
elseif (angriffszaehler + 1) / 4 == 1 then
SouthernAttackUnlimitedArmyGenerator:AddLeaderType(Entities.PU_LeaderSword2, 4, 1, 3, true)
SouthernAttackUnlimitedArmyGenerator:AddLeaderType(Entities.PU_LeaderPoleArm2, 4, 1, 3, true)
SouthernAttackUnlimitedArmyGenerator:AddLeaderType(Entities.PU_LeaderBow2, 4, 1, 3, true)
SouthernAttackUnlimitedArmyGenerator:RemoveLeaderType(Entities.PU_LeaderSword1)
SouthernAttackUnlimitedArmyGenerator:RemoveLeaderType(Entities.PU_LeaderPoleArm1)
SouthernAttackUnlimitedArmyGenerator:RemoveLeaderType(Entities.PU_LeaderBow1)
elseif (angriffszaehler + 1) / 4 == 2 then
SouthernAttackUnlimitedArmyGenerator:AddLeaderType(Entities.PU_LeaderSword3, 8, 1, 3, true)
SouthernAttackUnlimitedArmyGenerator:AddLeaderType(Entities.PU_LeaderPoleArm3, 8, 1, 3, true)
SouthernAttackUnlimitedArmyGenerator:AddLeaderType(Entities.PU_LeaderBow3, 8, 1, 3, true)
SouthernAttackUnlimitedArmyGenerator:AddLeaderType(Entities.PU_LeaderCavalry1, 3, 1, 3, true)
SouthernAttackUnlimitedArmyGenerator:AddLeaderType(Entities.PU_LeaderHeavyCavalry1, 3, 1, 3, true)
SouthernAttackUnlimitedArmyGenerator:AddLeaderType(Entities.PV_Cannon3, 0, 1, 0, true)
SouthernAttackUnlimitedArmyGenerator:RemoveLeaderType(Entities.PU_LeaderSword2)
SouthernAttackUnlimitedArmyGenerator:RemoveLeaderType(Entities.PU_LeaderPoleArm2)
SouthernAttackUnlimitedArmyGenerator:RemoveLeaderType(Entities.PU_LeaderBow2)
SouthernAttackUnlimitedArmyGenerator:RemoveLeaderType(Entities.PV_Cannon2)
SouthernAttackUnlimitedArmyGenerator:RemoveLeaderType(Entities.PV_Cannon1)
elseif (angriffszaehler + 1) / 4 == 3 then
SouthernAttackUnlimitedArmyGenerator:AddLeaderType(Entities.PU_LeaderSword4, 8, 1, 3, true)
SouthernAttackUnlimitedArmyGenerator:AddLeaderType(Entities.PU_LeaderPoleArm4, 8, 1, 3, true)
SouthernAttackUnlimitedArmyGenerator:AddLeaderType(Entities.PU_LeaderBow4, 8, 1, 3, true)
SouthernAttackUnlimitedArmyGenerator:AddLeaderType(Entities.PU_LeaderCavalry2, 3, 1, 3, true)
SouthernAttackUnlimitedArmyGenerator:AddLeaderType(Entities.PU_LeaderHeavyCavalry2, 3, 1, 3, true)
SouthernAttackUnlimitedArmyGenerator:AddLeaderType(Entities.PV_Cannon4, 0, 1, 0, true)
SouthernAttackUnlimitedArmyGenerator:RemoveLeaderType(Entities.PU_LeaderSword3)
SouthernAttackUnlimitedArmyGenerator:RemoveLeaderType(Entities.PU_LeaderPoleArm3)
SouthernAttackUnlimitedArmyGenerator:RemoveLeaderType(Entities.PU_LeaderBow3)
SouthernAttackUnlimitedArmyGenerator:RemoveLeaderType(Entities.PU_LeaderHeavyCavalry1)
SouthernAttackUnlimitedArmyGenerator:RemoveLeaderType(Entities.PU_LeaderCavalry1)
elseif (angriffszaehler + 1) / 4 == 4 then
Logic.SetTechnologyState(3, Technologies.T_LeatherMailArmor, 3)
Logic.SetTechnologyState(3, Technologies.T_ChainMailArmor, 3)
Logic.SetTechnologyState(3, Technologies.T_PlateMailArmor, 3)
Logic.SetTechnologyState(3, Technologies.T_SoftArcherArmor, 3)
Logic.SetTechnologyState(3, Technologies.T_PaddedArcherArmor, 3)
Logic.SetTechnologyState(3, Technologies.T_LeatherArcherArmor, 3)
Logic.SetTechnologyState(3, Technologies.T_MasterOfSmithery, 3)
Logic.SetTechnologyState(3, Technologies.T_IronCasting, 3)
Logic.SetTechnologyState(3, Technologies.T_Fletching, 3)
Logic.SetTechnologyState(3, Technologies.T_BodkinArrow, 3)
Logic.SetTechnologyState(3, Technologies.T_WoodAging, 3)
Logic.SetTechnologyState(3, Technologies.T_Turnery, 3)
Logic.SetTechnologyState(3, Technologies.T_EnhancedGunPowder, 3)
Logic.SetTechnologyState(3, Technologies.T_BlisteringCannonballs, 3)
Logic.SetTechnologyState(3, Technologies.T_BetterTrainingBarracks, 3)
Logic.SetTechnologyState(3, Technologies.T_BetterTrainingArchery, 3)
Logic.SetTechnologyState(3, Technologies.T_Shoeing, 3)
Logic.SetTechnologyState(3, Technologies.T_Masonry, 3)
end
SouthernAttackUnlimitedArmyGenerator:ResetCounter()
return true
end

Wegeentscheider = function()
  if math.random(100)>50 then
    return true, UnlimitedArmy.CreateCommandMove(GetPosition("attack2"))
  else
    return true, UnlimitedArmy.CreateCommandMove(GetPosition("attack23"))
  end
end

Check_ArmySoldiers = function ()
    for hochzahl,id in ipairs(SouthernAttackUnlimitedArmy.Leaders) do
			if Logic.LeaderGetNumberOfSoldiers(id)<1 and Logic.LeaderGetMaxNumberOfSoldiers(id)>0 and not Table_Check(armychecktable, id) then
				table.insert(armychecktable, 1, {id,15})
			end
    end
	if table.getn(armychecktable) < 1 then
		return false
	else
		for ccounter = table.getn(armychecktable), 1,-1 do
			if armychecktable[ccounter][2] == 0 then
				if IsValid(armychecktable[ccounter][1]) then
				SetHealth(armychecktable[ccounter][1],0)
				end 
				table.remove(armychecktable, ccounter)
			else
				armychecktable[ccounter][2] = armychecktable[ccounter][2] - 1
			end
		end
	end
	return false
end

Table_Check = function(tableinsert,ida)
for k,tableinsertis in ipairs(tableinsert) do
    if tableinsertis[1] == ida then
      return true
    end
  end
  return false
end