--------------------------------------------------------------------------------
-- MapName: Cleycourt
--
-- urspruenglicher Author: Peter Sprys
-- schwere Version: schmeling65
--------------------------------------------------------------------------------

-- Include main function
Script.Load( Folders.MapTools.."Main.lua" )
Script.Load(Folders.MapTools.."Technologies_ForbidAll.lua")


--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called from main script to initialize the diplomacy states
function Mission_InitDiplomacy()
	Logic.SetDiplomacyState( 1, 7, Diplomacy.Hostile )
end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called to set the player colors
function Mission_InitPlayerColorMapping()

--  Player _DstPlayerID will use color of player _SrcPlayerID. Params: _DstPlayerID, _SrcPlayerID.
	Display.SetPlayerColorMapping(1,PLAYER_COLOR)
	Display.SetPlayerColorMapping(2,NPC_COLOR)
	Display.SetPlayerColorMapping(3,BARMECIA_COLOR)
	Display.SetPlayerColorMapping(4,CLEYCOURT_COLOR)
	Display.SetPlayerColorMapping(7,KERBEROS_COLOR)
	Display.SetPlayerColorMapping(8,NPC_COLOR)

end
	

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called from main script to init all resources for player(s)
function Mission_InitResources()

	GeneratePlayerResources(3)

end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called to setup Technology states on mission start
-- see Player_1.lua !!!
function Mission_InitTechnologies()

end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start to initialize ai for all ai players
function Mission_InitAI()
end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start and after save game is loaded, setup your weather gfx
-- sets here
function Mission_InitWeatherGfxSets()

	Display.SetRenderUseGfxSets(1)
	
	WeatherSets_SetupNormal(1)
	WeatherSets_SetupRain(2)
	WeatherSets_SetupSnow(3)
end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start you should setup your weather periods here
function Mission_InitWeather()

	Logic.AddWeatherElement(1, 5, 1, 1, 5, 10)

end
	
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start after all initialization is done
function Mission_FirstMapAction()
	String.Init("CM01_06_Cleycourt_txt")

	IncludeLocals("Cutscene_Control")

	-- Load mission files
	IncludeLocals("army_p7defense")
	IncludeLocals("army_p7ironmine")
	
	IncludeLocals("GetRandom")
	IncludeLocals("CopyTable")
	IncludeLocals("GetDistance")
	IncludeLocals("IsEntityOfType")
	IncludeLocals("GetCirclePosition")
	IncludeLocals("GetAngleBetween")
	IncludeLocals("TriggerFix")
	IncludeLocals("EntityIdChangedHelper")
	IncludeLocals("UnlimitedArmy")
	IncludeLocals("UnlimitedArmySpawnGenerator")

	IncludeLocals("briefing_aribase")
	IncludeLocals("briefing_catchari")
	IncludeLocals("briefing_leonardo")
	IncludeLocals("briefing_orb")
	IncludeLocals("briefing_prelude")
	IncludeLocals("briefing_uni")
	IncludeLocals("briefing_warning")
	IncludeLocals("briefing_trader1")
	IncludeLocals("briefing_trader1end")
	IncludeLocals("briefing_trader2")
	IncludeLocals("briefing_trader2end")
	IncludeLocals("briefing_GuardWaterfall")
	
	IncludeLocals("gameControl")

	IncludeLocals("player_1")
	IncludeLocals("player_3")
	IncludeLocals("player_4")
	IncludeLocals("player_7")

	IncludeLocals("quest_builduni")
	IncludeLocals("quest_catchari")
	IncludeLocals("quest_defeat")
	IncludeLocals("quest_findari")
	IncludeLocals("quest_freechest")
	IncludeLocals("quest_getkey")
	IncludeLocals("quest_leomovenearmachine")
	IncludeLocals("quest_opengate")
	IncludeLocals("quest_trader1")
	IncludeLocals("quest_trader2")
	IncludeLocals("quest_ReachBarmeciaMayor")
	IncludeLocals("quest_NearGateNoKey")


	LocalMusic.UseSet = EUROPEMUSIC
		
	
	String.Init("CM01_06_Cleycourt_Txt")

	--	chest handling

		CreateChestOpener("Dario")
		CreateChestOpener("Erec")
		CreateChestOpener("Helias")
--		CreateChestOpener("Ari")
--		CreateChestOpener("Pilgrim")
--		CreateChestOpener("Salim")
	
		CreateRandomGoldChests()
		CreateRandomChests()
		
		StartChestQuest()


	
	-- Start prelude
	start1stQuest()
	-- Start time line
	TimeLine.Start()
	EntityIdChangedHelper.Init()

--	EnableDebugging()

end
