-------------------------------------------------------------------------------
-- MapName: 	Village Attack
--
-- urspruenglicher Author: 		Andreas Nitsche, Thomas Friedmann
-- schwere Version: schmeling65
--------------------------------------------------------------------------------

-- 	Include main function

	Script.Load(Folders.MapTools.."Main.lua")
	Script.Load(Folders.MapTools.."Technologies_ForbidAll.lua")	--TF

	--	globals
	
		IncludeGlobals("MapSettings_Main")

	--	locals

		IncludeLocals("Cutscene_Control")

		IncludeLocals("gameControl")
	
		IncludeLocals("player_1")
		IncludeLocals("player_2")
		IncludeLocals("player_3")
		IncludeLocals("player_4")
		IncludeLocals("player_5")
		
		IncludeLocals("quest_hireTroops")
		IncludeLocals("quest_defeat")
		IncludeLocals("quest_rescueLeonardo")
		IncludeLocals("quest_defendCastle")
		IncludeLocals("quest_merchant")
		IncludeLocals("quest_defendVillage1")
		IncludeLocals("quest_searchMayor1")
		
		IncludeLocals("briefing_defendCastle")
		IncludeLocals("briefing_erecsArrival")
		IncludeLocals("briefing_moveToCastle")
		IncludeLocals("briefing_supportVillage1")
		IncludeLocals("briefing_leonardoDialog")
		IncludeLocals("briefing_FreeLeonardoHint")
		IncludeLocals("briefing_mayorDialog")
		IncludeLocals("briefing_merchantDialog")
		IncludeLocals("briefing_searchMayor1")
		IncludeLocals("briefing_supportVillageGoOn")
		IncludeLocals("briefing_robber1Attack")
		IncludeLocals("briefing_robber2Attack")
		IncludeLocals("briefing_VillageArmyComes")
		
		IncludeLocals("army_attack1")
		IncludeLocals("army_attack2")
		IncludeLocals("army_cave1")
		IncludeLocals("army_cave2")
		IncludeLocals("army_defendMine")
		IncludeLocals("army_defendRoute")
		IncludeLocals("army_defendIron")
		IncludeLocals("army_defendCamps")
		IncludeLocals("army_siege")
		IncludeLocals("army_erec")
		
		IncludeLocals("CopyTable")
		IncludeLocals("GetAngleBetween")
		IncludeLocals("GetCirclePosition")
		IncludeLocals("GetDistance")
		IncludeLocals("IsEntityOfType")
		IncludeLocals("TriggerFix")
		IncludeLocals("EntityIdChangedHelper")
		IncludeLocals("UnlimitedArmy")
		IncludeLocals("GetRandom")
	
	
		IncludeLocals("Map_LocalInit")		--TF_Include!
		
		
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called from main script to initialize the diplomacy states
function Mission_InitDiplomacy()

	Logic.SetDiplomacyState( 1, 2, Diplomacy.Hostile	)
	Logic.SetDiplomacyState( 1, 3, Diplomacy.Hostile 	)
	Logic.SetDiplomacyState( 1,	4, Diplomacy.Friendly 	)
	Logic.SetDiplomacyState( 1,	5, Diplomacy.Friendly 	)

	Logic.SetDiplomacyState( 2, 3, Diplomacy.Friendly 	)

	Logic.SetDiplomacyState( 4,	5, Diplomacy.Friendly 	)
	Logic.SetDiplomacyState( 4,	2, Diplomacy.Hostile 	)
	Logic.SetDiplomacyState( 4,	3, Diplomacy.Hostile 	)

	Logic.SetDiplomacyState( 5,	2, Diplomacy.Hostile 	)
	Logic.SetDiplomacyState( 5,	3, Diplomacy.Hostile 	)

	end


--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called to set the player colors
function Mission_InitPlayerColorMapping()

	
		Display.SetPlayerColorMapping(2, KERBEROS_COLOR)		-- Robbers
		Display.SetPlayerColorMapping(3, KERBEROS_COLOR)		-- Attackers from Cave

		Display.SetPlayerColorMapping(4, FRIENDLY_COLOR1)		-- Oberkirch
		Display.SetPlayerColorMapping(5, FRIENDLY_COLOR2)		-- Unterbach

		Display.SetPlayerColorMapping(7, 1)						-- VC in palyer's village

		Display.SetPlayerColorMapping(8, NPC_COLOR)				-- Trader
		
end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called from main script to init all resources for player(s)
function Mission_InitResources()

	end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called to setup Technology states on mission start
function Mission_InitTechnologies()

	end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start to initialize ai for all ai players
function Mission_InitAI()

	end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start and after save game is loaded, setup your weather gfx
-- sets here
function Mission_InitWeatherGfxSets()

	Display.SetRenderUseGfxSets(1)
	
	WeatherSets_SetupNormal(1)
	WeatherSets_SetupRain(2)
	WeatherSets_SetupSnow(3)

end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start you should setup your weather periods here
function Mission_InitWeather()

	Logic.SetupGfxSet(1)
	
	Logic.AddWeatherElement(1, 3000, 1, 1, 5, 10)
	Logic.AddWeatherElement(2,   60, 1, 2, 5, 10)
  
		-- [fun]  AddWeatherElement
		--          Add weather period on end of periods.
		-- Param1: Weather State of period, 1 = normal, 2 = rain, 3 = snow
		-- Param2: Duration of period in seconds
		-- Param3: Is periodic, 1 for (normal)periodic weather element else 0 for weather machine effects
		-- Param4: Gfx Set of this weather element
		-- Param5: Gfx Set forerun (gfx transition start some time before logic state change), time in seconds
		-- Param6: duration of Gfx Set transition
 
end

	
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start after all initialization is done
function Mission_FirstMapAction()


	--	chest handling

		CreateChestOpener("Dario")
		CreateChestOpener("Erec")
--		CreateChestOpener("Ari")
--		CreateChestOpener("Pilgrim")
--		CreateChestOpener("Salim")
--		CreateChestOpener("Helias")
	
		CreateRandomGoldChests()
		
		StartChestQuest()
		
	--	default actions	
		
		String.Init("CM01_02_VillageAttack_Txt")

		setup_Map02()

	--	create all players

		createPlayer1()
		createPlayer2()
		createPlayer3()
		createPlayer4()
		createPlayer5()

	-- Set Music-Set
		LocalMusic.UseSet = EUROPEMUSIC
		
		EntityIdChangedHelper.Init()

	--	entry point

		startQuestMoveToCastle()
	
	end



